<?php
require "../../controlador/membresiaControlador.php";
require "../../modelo/membresiaModelo.php";

$id = $_GET["id"];
$membresia = ControladorMembresia::ctrInfoMembresia($id);
?>
<div class="modal-header bg-dark">
  <h4 class="modal-title font-weight-light">Editar Membresia</h4>
  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
<form action="" id="FormEditMembresia">
  <div class="modal-body row">
    <div class="form-group col-md-12">
      <label for="">Descripción</label>
      <input type="text" class="form-control" id="descripcion" name="descripcion" value="<?php echo $membresia['descripcion'];?>">
      <input type="hidden" name="idMembresia" value="<?php echo $membresia['id_membresia'];?>">
    </div>
    <div class="form-group col-md-6">
      <label for="">Costo</label>
      <input type="number" class="form-control" id="costo" name="costo" value="<?php echo $membresia['costo'];?>">
    </div>

    <div class="form-group col-md-6">
      <label for="">Estado</label>
      <select name="estado" id="estado" class="form-control">
        <option value="1" <?php if ($membresia["estado"] == 1) : ?> selected <?php endif; ?>>Activo</option>
        <option value="0" <?php if ($membresia["estado"] == 0) : ?> selected <?php endif; ?>>Inactivo</option>
      </select>
    </div>
  </div>
  <div class="modal-footer justify-content-between">
    <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
    <button type="submit" class="btn btn-primary">Actualizar</button>
  </div>
</form>

<script>
  $(function() {
    $.validator.setDefaults({
      submitHandler: function() {
        EditMembresia()
      }
    })
    $(document).ready(function() {
      $("#FormEditMembresia").validate({
        rules: {
          descripcion: {
            required: true,
            minlength: 3
          },
          costo: {
            required: true,
          }
        },
        errorElement: 'span',
        errorPlacement: function(error, element) {
          error.addClass('invalid-feedback')
          element.closest('.form-group').append(error)
        },

        highlight: function(element, errorClass, validClass) {
          $(element).addClass('is-invalid')
        },

        unhighlight: function(element, errorClass, validClass) {
          $(element).removeClass('is-invalid')
        }

      })
    })

  })
</script>