<?php
require "../../controlador/inscripcionControlador.php";
require "../../modelo/inscripcionModelo.php";

$id = $_GET["id"];
$inscripcion = ControladorInscripcion::ctrInfoInscripcion($id);

?>
<div class="modal-header bg-dark">
  <h4 class="modal-title font-weight-light">Información de Inscripcion</h4>
  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
<div class="modal-body">
  <div class="row">
    <div class="col-sm-12">
      <table class="table">
        <tr>
          <th>Cliente</th>
          <td><?php echo $inscripcion["nombre_cliente"]." ".$inscripcion["ap_paterno_cli"]." ".$inscripcion["ap_materno_cli"]; ?></td>
        </tr>

        <tr>
          <th>C.I./NIT Cliente</th>
          <td><?php echo $inscripcion["ci_cliente"]; ?></td>
        </tr>

        <tr>
          <th>Tipo de membresia</th>
          <td><?php echo $inscripcion["descripcion"]; ?></td>
        </tr>

        <tr>
          <th>Costo (Bs)</th>
          <td><?php echo $inscripcion["costo"]; ?></td>
        </tr>

        <tr>
          <th>Descuento (%)</th>
          <td><?php echo $inscripcion["descuento"]; ?></td>
        </tr>

        <tr>
          <th>Total (Bs)</th>
          <td><b><?php 
            $costo=$inscripcion["costo"];
            $descuento=$inscripcion["descuento"];
            $total=$costo-(($costo/100)*$descuento);

            echo number_format($total, 2, '.', ''); ?></b></td>
        </tr>

        <tr>
          <th>Inscrito en</th>
          <td><?php echo $inscripcion["fecha_inscripcion"]; ?></td>
        </tr>
        <tr>
          <th>Registrado por</th>
          <td><?php echo $inscripcion["nombre"]; ?></td>
        </tr>
        <tr>
          <th>Inicio</th>
          <td><?php echo $inscripcion["fecha_inicio"]; ?></td>
        </tr>
        <tr>
          <th>Final</th>
          <td><?php echo $inscripcion["fecha_fin"]; ?></td>
        </tr>

        <tr>
          <th>Estado Inscripcion</th>
          <?php
          if ($inscripcion["estado"] == 1) {
          ?>
          <td><span class="badge badge-success">Vigente</span></td>
          <?php
          } else {
          ?>
          <td><span class="badge badge-danger">Caducado</span></td>
          <?php
          }
          ?>
        </tr>

      </table>

    </div>
  </div>

</div>