<?php
require "../../controlador/inscripcionControlador.php";
require "../../modelo/inscripcionModelo.php";

$id = $_GET["id"];
$inscripcion = ControladorInscripcion::ctrInfoInscripcion($id);
?>


<div class="modal-header bg-dark">
  <h4 class="modal-title font-weight-light">Editar Inscripcion</h4>
  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
<form action="" id="FormEditInscripcion">
  <div class="modal-body">
    <div class="row">
      <div class="col-sm-12">
        <div class="form-group">
          <label for="">Cliente</label>
          <input type="text" name="cliente" id="cliente" class="form-control" value="<?php echo $inscripcion["nombre_cliente"]." ".$inscripcion["ap_paterno_cli"]." ".$inscripcion["ap_materno_cli"]; ?>" readonly>
          <input type="hidden" name="idInscripcion" value="<?php echo $id;?>">
        </div>
      </div>
      <div class="col-sm-12">
        <div class="form-group">
          <label for="">Membresia</label>
          <select name="membresia" id="membresia" class="form-control">
            <option value="">Seleccionar</option>
            <?php
            require "../../controlador/membresiaControlador.php";
            require "../../modelo/membresiaModelo.php";
            $membresia=ControladorMembresia::ctrInformacionMembresia();
            foreach($membresia as $value){
              if($value["descripcion"]==$inscripcion["descripcion"]){
            ?>
            <option value="<?php echo $value["id_membresia"];?>" selected><?php echo $value["descripcion"]." - ".$value["costo"];?></option>
            <?php
              }else{
            ?>
            <option value="<?php echo $value["id_membresia"];?>"><?php echo $value["descripcion"]." - ".$value["costo"];?></option>
            <?php
              }
            }
            ?>
          </select>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-sm-6">
        <div class="form-group">
          <label for="">Decuento(%)</label>
          <input type="number" class="form-control" id="descuento" name="descuento" value="<?php echo $inscripcion["descuento"];?>">
        </div>
      </div>
      <div class="col-sm-6">
        <div class="form-group">
          <label for="">Estado</label>
          <select name="estado" id="estado" class="form-control">
            <option value="1" <?php if ($inscripcion["estado"] == 1) : ?> selected <?php endif; ?>>Vigente</option>
            <option value="0" <?php if ($inscripcion["estado"] == 0) : ?> selected <?php endif; ?>>Caducado</option>
          </select>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-sm-6">
        <div class="form-group">
          <label for="">Fecha de Inicio</label>
          <input type="date" class="form-control" id="fechaInicio" name="fechaInicio" value="<?php echo $inscripcion["fecha_inicio"];?>">
        </div>
      </div>
      <div class="col-sm-6">
        <div class="form-group">
          <label for="">Fecha de Fin</label>
          <input type="date" class="form-control" id="fechaFin" name="fechaFin" value="<?php echo $inscripcion["fecha_fin"];?>">
        </div>  
      </div>
    </div>

  </div>
  <div class="modal-footer justify-content-between">
    <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
    <button type="submit" class="btn btn-primary" id="guardar">Guardar</button>
  </div>
</form>


<script>
  $(function(){
    $.validator.setDefaults({

      submitHandler:function(){
        EditInscripcion()
      }
    })
    $(document).ready(function(){
      $("#FormEditInscripcion").validate({
        rules:{
          cliente:{
            required:true
          },
          membresia:{
            required: true
          },
          descuento:{
            required:true
          },
          fechaInicio:{
            required:true
          },
          fechaFin:{
            required:true
          }
        },
        errorElement:'span',
        errorPlacement:function(error, element){
          error.addClass('invalid-feedback')
          element.closest('.form-group').append(error)
        },

        highlight: function(element, errorClass, validClass){
          $(element).addClass('is-invalid')
        },

        unhighlight: function(element, errorClass, validClass){
          $(element).removeClass('is-invalid')
        }

      })
    })

  })

</script>