<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <div class="container-fluid">
      <!-- Aquí puedes agregar contenido adicional si lo necesitas -->
    </div><!-- /.container-fluid -->
  </section>

  <section class="content">
    <h5 class="table-title">
      Reportes
    </h5>

    <!-- Formulario para seleccionar el rango de fechas -->
    <form method="POST">
      <div class="row">
        <div class="col-md-4">
          <label for="fechaInicio">Fecha de Inicio:</label>
          <input type="date" id="fechaInicio" name="fechaInicio" class="form-control" required>
        </div>
        <div class="col-md-4">
          <label for="fechaFin">Fecha de Fin:</label>
          <input type="date" id="fechaFin" name="fechaFin" class="form-control" required>
        </div>
        <div class="col-md-4 align-self-end">
          <button type="submit" class="btn btn-primary">Buscar</button>
        </div>
      </div>
    </form>

    <!-- Tabla de resultados -->
    <table id="DataTable" class="table table-bordered table-striped mt-3">
      <thead>
        <tr>
          <th>Cliente</th>
          <th>Membresia</th>
           <th>Pagos</th>
           <th>Fecha</th>
          <th>Estado</th>
        </tr>
      </thead>
      <tbody>
        <?php 
        // Verifica si las fechas fueron enviadas por el formulario
        if (isset($_POST['fechaInicio']) && isset($_POST['fechaFin'])) {
          $fechaInicio = $_POST['fechaInicio'];
          $fechaFin = $_POST['fechaFin'];

          // Llama al controlador pasando las fechas seleccionadas
          $inscripcion = ControladorReporte::ctrReportes($fechaInicio, $fechaFin);

          // Recorre los resultados y los muestra en la tabla
          foreach ($inscripcion as $value) {
        ?>
        <tr>
          <td><?php echo $value["nombre_cliente"] . " " . $value["ap_paterno_cli"] . " " . $value["ap_materno_cli"]; ?></td>
          <td><?php echo $value["descripcion"]; ?></td>
          <td><?php echo $value["costo"]; ?></td>
          <td><?php echo $value["fecha_inscripcion"]; ?></td>
          <td>
            <?php if ($value["estado"] == 1) { ?>
              <span class="badge badge-success">Vigente</span>
            <?php } else { ?>
              <span class="badge badge-danger">Caducado</span>
            <?php } ?>
          </td>
        </tr>
        <?php 
          } // Fin del foreach
        } // Fin del if
        ?>
      </tbody>
    </table>

  </section>
</div>
