<?php
require_once "conexion.php";

class ModeloReporte
{
    static public function mdlReportes($fechaInicio, $fechaFin)
    {
        try {
            $stmt = Conexion::conectar()->prepare("SELECT 
                id_inscripcion,
                nombre_cliente,
                ap_paterno_cli,
                ap_materno_cli,
                descripcion,
                fecha_inscripcion,
                costo,
                inscripcion.estado
            FROM inscripcion
            JOIN cliente ON cliente.id_cliente = inscripcion.id_cliente
            JOIN membresia ON membresia.id_membresia = inscripcion.id_membresia
            WHERE fecha_inscripcion >= :fechaInicio 
                AND fecha_inscripcion <= :fechaFin");
       
            $stmt->bindParam(":fechaInicio", $fechaInicio, PDO::PARAM_STR);
            $stmt->bindParam(":fechaFin", $fechaFin, PDO::PARAM_STR);
            
            $stmt->execute();
            $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            $stmt = null;
            
            return $resultados;
            
        } catch (PDOException $e) {
            return "Error: " . $e->getMessage();
        }
    }
}
?>